package ru.yandex.direct.api.v5.entity.negativekeywordsharedsets;

import com.yandex.direct.api.v5.negativekeywordsharedsets.AddRequest;
import com.yandex.direct.api.v5.negativekeywordsharedsets.AddResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.ApiException;
import com.yandex.direct.api.v5.negativekeywordsharedsets.DeleteRequest;
import com.yandex.direct.api.v5.negativekeywordsharedsets.DeleteResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.GetRequest;
import com.yandex.direct.api.v5.negativekeywordsharedsets.GetResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetsPort;
import com.yandex.direct.api.v5.negativekeywordsharedsets.UpdateRequest;
import com.yandex.direct.api.v5.negativekeywordsharedsets.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.delegate.AddNegativeKeywordSharedSetsDelegate;
import ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.delegate.DeleteNegativeKeywordSharedSetsDelegate;
import ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.delegate.GetNegativeKeywordSharedSetsDelegate;
import ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.delegate.UpdateNegativeKeywordSharedSetsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class NegativeKeywordSharedSetsEndpoint implements NegativeKeywordSharedSetsPort {
    private static final String SERVICE_NAME = "negativekeywordsharedsets";
    private final GenericApiService genericApiService;
    private final AddNegativeKeywordSharedSetsDelegate addNegativeKeywordSharedSetsDelegate;
    private final GetNegativeKeywordSharedSetsDelegate getNegativeKeywordSharedSetsDelegate;
    private final UpdateNegativeKeywordSharedSetsDelegate updateNegativeKeywordSharedSetsDelegate;
    private final DeleteNegativeKeywordSharedSetsDelegate deleteNegativeKeywordSharedSetsDelegate;

    @Autowired
    public NegativeKeywordSharedSetsEndpoint(GenericApiService genericApiService,
                                             AddNegativeKeywordSharedSetsDelegate addNegativeKeywordSharedSetsDelegate,
                                             GetNegativeKeywordSharedSetsDelegate getNegativeKeywordSharedSetsDelegate,
                                             UpdateNegativeKeywordSharedSetsDelegate updateNegativeKeywordSharedSetsDelegate,
                                             DeleteNegativeKeywordSharedSetsDelegate deleteNegativeKeywordSharedSetsDelegate) {
        this.genericApiService = genericApiService;
        this.addNegativeKeywordSharedSetsDelegate = addNegativeKeywordSharedSetsDelegate;
        this.getNegativeKeywordSharedSetsDelegate = getNegativeKeywordSharedSetsDelegate;
        this.updateNegativeKeywordSharedSetsDelegate = updateNegativeKeywordSharedSetsDelegate;
        this.deleteNegativeKeywordSharedSetsDelegate = deleteNegativeKeywordSharedSetsDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getNegativeKeywordSharedSetsDelegate, getRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) throws ApiException {
        return genericApiService.doAction(addNegativeKeywordSharedSetsDelegate, addRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "update")
    @ApiResponse
    @Override
    public UpdateResponse update(@ApiRequest UpdateRequest updateRequest) {
        return genericApiService.doAction(updateNegativeKeywordSharedSetsDelegate, updateRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest deleteRequest) {
        return genericApiService.doAction(deleteNegativeKeywordSharedSetsDelegate, deleteRequest);
    }
}
