package ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.converter;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetGetItem;
import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetUpdateItem;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.model.ModelChanges;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.api.v5.common.GeneralUtil.yesNoFromBool;

@ParametersAreNonnullByDefault
public class NegativeKeywordSharedSetsConverter {

    public static NegativeKeywordSharedSetGetItem convertGetResponse(Pair<MinusKeywordsPack, Long> packWithLinksCount) {
        MinusKeywordsPack pack = packWithLinksCount.getLeft();
        Long linkedAdGroupsCount = packWithLinksCount.getRight();

        return new NegativeKeywordSharedSetGetItem()
                .withId(pack.getId())
                .withName(pack.getName())
                .withNegativeKeywords(pack.getMinusKeywords())
                .withAssociated(yesNoFromBool(linkedAdGroupsCount > 0));
    }

    public static ModelChanges<MinusKeywordsPack> convertUpdateRequestToModelChanges(NegativeKeywordSharedSetUpdateItem item) {
        ModelChanges<MinusKeywordsPack> changes = new ModelChanges<>(item.getId(), MinusKeywordsPack.class);

        changes.processNotNull(item.getName(), MinusKeywordsPack.NAME);

        if (!isEmpty(item.getNegativeKeywords())) {
            changes.processNotNull(item.getNegativeKeywords(), MinusKeywordsPack.MINUS_KEYWORDS);
        }
        return changes;
    }
}
