package ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.negativekeywordsharedsets.AddRequest;
import com.yandex.direct.api.v5.negativekeywordsharedsets.AddResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.core.entity.minuskeywordspack.container.AddedMinusKeywordsPackInfo;
import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.core.entity.minuskeywordspack.service.MinusKeywordsPacksAddOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.api.v5.validation.DefectTypes.maxElementsPerRequest;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.MAX_LIBRARY_PACKS_COUNT;
import static ru.yandex.direct.result.ResultConverters.massResultValueConverter;
import static ru.yandex.direct.utils.converter.Converters.nullSafeConverter;

@Service
@ParametersAreNonnullByDefault
public class AddNegativeKeywordSharedSetsDelegate extends OperationOnListDelegate<AddRequest, AddResponse,
        MinusKeywordsPack, Long> {

    private MinusKeywordsPacksAddOperationFactory minusKeywordsPacksAddOperationFactory;
    private ShardHelper shardHelper;
    private ResultConverter resultConverter;

    @Autowired
    public AddNegativeKeywordSharedSetsDelegate(
            ApiAuthenticationSource apiAuthenticationSource,
            MinusKeywordsPacksAddOperationFactory minusKeywordsPacksAddOperationFactory,
            ShardHelper shardHelper, ResultConverter resultConverter) {
        super(ApiPathConverter.forNegativeKeywordSharedSets(), apiAuthenticationSource);
        this.minusKeywordsPacksAddOperationFactory = minusKeywordsPacksAddOperationFactory;
        this.shardHelper = shardHelper;
        this.resultConverter = resultConverter;
    }

    @Nullable
    @Override
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest externalRequest) {
        ItemValidationBuilder<AddRequest, DefectType> vb = ItemValidationBuilder.of(externalRequest);
        vb.list(externalRequest.getNegativeKeywordSharedSets(),
                AddRequest.PropInfo.NEGATIVE_KEYWORD_SHARED_SETS.propertyName)
                .check(maxListSize(MAX_LIBRARY_PACKS_COUNT), maxElementsPerRequest(MAX_LIBRARY_PACKS_COUNT));
        return vb.getResult();
    }

    @Override
    public List<MinusKeywordsPack> convertRequest(AddRequest externalRequest) {
        return externalRequest.getNegativeKeywordSharedSets().stream()
                .map(requestItem -> new MinusKeywordsPack()
                        .withName(requestItem.getName())
                        .withMinusKeywords(requestItem.getNegativeKeywords()))
                .collect(toList());
    }

    @Override
    public ApiMassResult<Long> processList(List<MinusKeywordsPack> validItems) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        MassResult<AddedMinusKeywordsPackInfo> packInfoMassResult =
                minusKeywordsPacksAddOperationFactory.newInstance(Applicability.PARTIAL, validItems,
                        MinusPhraseValidator.ValidationMode.ONE_ERROR_PER_TYPE,
                        clientId, shardHelper.getShardByClientId(clientId), false).prepareAndApply();
        MassResult<Long> idsMassResult =
                massResultValueConverter(nullSafeConverter(AddedMinusKeywordsPackInfo::getId))
                        .convert(packInfoMassResult);

        return resultConverter.toApiMassResult(idsMassResult);
    }

    @Override
    public AddResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new AddResponse().withAddResults(resultConverter.toActionResults(result, apiPathConverter));
    }
}
