package ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.delegate;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.general.IdsCriteria;
import com.yandex.direct.api.v5.negativekeywordsharedsets.DeleteRequest;
import com.yandex.direct.api.v5.negativekeywordsharedsets.DeleteResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.minuskeywordspack.service.MinusKeywordsPacksDeleteOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.api.v5.validation.DefectTypes.duplicatedObject;
import static ru.yandex.direct.api.v5.validation.DefectTypes.maxElementsPerRequest;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.eachNotNull;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.unique;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.MAX_LIBRARY_PACKS_COUNT;

@Service
@ParametersAreNonnullByDefault
public class DeleteNegativeKeywordSharedSetsDelegate extends OperationOnListDelegate<DeleteRequest, DeleteResponse,
        Long, Long> {

    private MinusKeywordsPacksDeleteOperationFactory minusKeywordsPacksDeleteOperationFactory;
    private ShardHelper shardHelper;
    private ResultConverter resultConverter;

    @Autowired
    public DeleteNegativeKeywordSharedSetsDelegate(
            ApiAuthenticationSource apiAuthenticationSource,
            MinusKeywordsPacksDeleteOperationFactory minusKeywordsPacksDeleteOperationFactory,
            ShardHelper shardHelper, ResultConverter resultConverter) {

        super(MappingPathConverter.builder(DeleteNegativeKeywordSharedSetsDelegate.class, "emptyConverter")
                .build(), apiAuthenticationSource);

        this.minusKeywordsPacksDeleteOperationFactory = minusKeywordsPacksDeleteOperationFactory;
        this.shardHelper = shardHelper;
        this.resultConverter = resultConverter;
    }

    @Nullable
    @Override
    public ValidationResult<DeleteRequest, DefectType> validateRequest(DeleteRequest externalRequest) {
        ItemValidationBuilder<DeleteRequest, DefectType> vb = ItemValidationBuilder.of(externalRequest);
        vb.list(externalRequest.getSelectionCriteria().getIds(), "Ids")
                .check(eachNotNull())
                .check(maxListSize(MAX_LIBRARY_PACKS_COUNT), maxElementsPerRequest(MAX_LIBRARY_PACKS_COUNT));
        return vb.getResult();
    }

    @Nonnull
    @Override
    public ValidationResult<List<Long>, DefectType> validateInternalRequest(List<Long> internalRequest) {
        return ListValidationBuilder.<Long, DefectType>of(internalRequest)
                .checkEach(unique(), duplicatedObject(), When.isValid())
                .getResult();
    }

    @Override
    public List<Long> convertRequest(DeleteRequest deleteRequest) {
        IdsCriteria criteria = deleteRequest.getSelectionCriteria();
        return criteria != null ? criteria.getIds() : emptyList();
    }

    @Override
    public ApiMassResult<Long> processList(List<Long> ids) {
        ClientId clientId = auth.getChiefSubclient().getClientId();

        MassResult<Long> packInfoMassResult =
                minusKeywordsPacksDeleteOperationFactory.newInstance(
                        Applicability.PARTIAL,
                        ids,
                        clientId,
                        shardHelper.getShardByClientId(clientId)
                ).prepareAndApply();

        return resultConverter.toApiMassResult(packInfoMassResult);
    }

    @Override
    public DeleteResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new DeleteResponse().withDeleteResults(resultConverter.toActionResults(result, apiPathConverter));
    }
}
