package ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.delegate;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.general.IdsCriteria;
import com.yandex.direct.api.v5.negativekeywordsharedsets.GetRequest;
import com.yandex.direct.api.v5.negativekeywordsharedsets.GetResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetFieldEnum;
import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetGetItem;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.common.EnumPropertyFilter;
import ru.yandex.direct.api.v5.entity.GenericGetRequest;
import ru.yandex.direct.api.v5.entity.GetApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.converter.NegativeKeywordSharedSetsConverter;
import ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.validation.GetNegativeKeywordSharedSetsValidationService;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.util.PropertyFilter;
import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class GetNegativeKeywordSharedSetsDelegate extends
        GetApiServiceDelegate<GetRequest, GetResponse, NegativeKeywordSharedSetFieldEnum, Set<Long>,
                Pair<MinusKeywordsPack, Long>> {

    private final MinusKeywordsPackRepository packRepository;
    private final ShardHelper shardHelper;
    private final EnumPropertyFilter<NegativeKeywordSharedSetFieldEnum> propertyFilter;
    private final GetNegativeKeywordSharedSetsValidationService validationService;


    @Autowired
    public GetNegativeKeywordSharedSetsDelegate(
            ApiAuthenticationSource auth,
            MinusKeywordsPackRepository packRepository, ShardHelper shardHelper,
            PropertyFilter propertyFilter, GetNegativeKeywordSharedSetsValidationService validationService) {
        super(MappingPathConverter.builder(GetNegativeKeywordSharedSetsDelegate.class, "emptyConverter").build(),
                auth);
        this.packRepository = packRepository;
        this.shardHelper = shardHelper;
        this.propertyFilter = EnumPropertyFilter.from(NegativeKeywordSharedSetFieldEnum.class, propertyFilter);
        this.validationService = validationService;
    }

    @Override
    public ValidationResult<GetRequest, DefectType> validateRequest(GetRequest externalRequest) {
        return validationService.validateRequest(externalRequest);
    }

    @Override
    public Set<NegativeKeywordSharedSetFieldEnum> extractFieldNames(GetRequest externalRequest) {
        return new HashSet<>(externalRequest.getFieldNames());
    }

    @Override
    public Set<Long> extractSelectionCriteria(GetRequest externalRequest) {
        IdsCriteria selectionCriteria = externalRequest.getSelectionCriteria();
        return selectionCriteria == null ? null : new HashSet<>(selectionCriteria.getIds());
    }

    @Override
    public List<Pair<MinusKeywordsPack, Long>> get(
            GenericGetRequest<NegativeKeywordSharedSetFieldEnum, Set<Long>> getRequest) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        int shard = shardHelper.getShardByClientId(clientId);

        return packRepository.getLibraryPacksWithLinksCount(
                shard,
                clientId,
                getRequest.getSelectionCriteria(),
                getRequest.getLimitOffset());

    }

    @Override
    public GetResponse convertGetResponse(List<Pair<MinusKeywordsPack, Long>> result,
                                          Set<NegativeKeywordSharedSetFieldEnum> requestedFields,
                                          @Nullable Long limitedBy) {
        GetResponse response = new GetResponse().withLimitedBy(limitedBy);

        if (!result.isEmpty()) {
            List<NegativeKeywordSharedSetGetItem> convertedItems =
                    mapList(result, NegativeKeywordSharedSetsConverter::convertGetResponse);

            propertyFilter.filterProperties(convertedItems, requestedFields);
            response.withNegativeKeywordSharedSets(convertedItems);
        }
        return response;
    }


}
