package ru.yandex.direct.api.v5.entity.negativekeywordsharedsets.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.general.IdsCriteria;
import com.yandex.direct.api.v5.negativekeywordsharedsets.GetRequest;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.validation.GetRequestGeneralValidator;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static com.yandex.direct.api.v5.general.IdsCriteria.PropInfo.IDS;
import static com.yandex.direct.api.v5.negativekeywordsharedsets.GetRequest.PropInfo.SELECTION_CRITERIA;
import static ru.yandex.direct.api.v5.validation.DefectTypes.maxIdsInSelection;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.MAX_LIBRARY_PACKS_COUNT;

@Service
@ParametersAreNonnullByDefault
public class GetNegativeKeywordSharedSetsValidationService {

    private static final String SELECTION_CRITERIA_FIELD = SELECTION_CRITERIA.schemaName.toString();

    public ValidationResult<GetRequest, DefectType> validateRequest(GetRequest externalRequest) {
        ItemValidationBuilder<GetRequest, DefectType> vb = ModelItemValidationBuilder.of(externalRequest);
        vb.checkBy(GetRequestGeneralValidator::validateRequestWithDefectTypes);

        vb.item(externalRequest.getSelectionCriteria(), SELECTION_CRITERIA_FIELD)
                .checkBy(this::validateSelectionCriteria, When.notNull());

        return vb.getResult();
    }

    private ValidationResult<IdsCriteria, DefectType> validateSelectionCriteria(IdsCriteria selectionCriteria) {
        ItemValidationBuilder<IdsCriteria, DefectType> vb = ItemValidationBuilder.of(selectionCriteria);
        vb.item(selectionCriteria.getIds(), IDS.schemaName.toString())
                .check(maxListSize(MAX_LIBRARY_PACKS_COUNT), maxIdsInSelection());
        return vb.getResult();
    }
}
