package ru.yandex.direct.api.v5.entity.organizations;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.organizations.validation.OrganizationDefectTranslations;

import static ru.yandex.direct.api.v5.validation.DefectTypes.badStatus;
import static ru.yandex.direct.api.v5.validation.DefectTypes.inconsistentState;
import static ru.yandex.direct.api.v5.validation.DefectTypes.notFound;

public class OrganizationsDefectTypes {
    private OrganizationsDefectTypes() {
    }

    private static OrganizationDefectTranslations organizationDefectTranslations() {
        return OrganizationDefectTranslations.INSTANCE;
    }

    public static DefectType organizationNotFound() {
        return notFound().withDetailedMessage(organizationDefectTranslations().organizationNotFound());
    }

    public static DefectType invalidPreferVCardOverPermalink() {
        return inconsistentState().withDetailedMessage(organizationDefectTranslations().invalidPreferVCardOverPermalink());
    }

    public static DefectType hasNoAccessToOrganization() {
        return inconsistentState().withDetailedMessage(organizationDefectTranslations().hasNoAccessToOrganization());
    }

    public static DefectType eitherPermalinkOrChainCanBeFilled() {
        return inconsistentState().withDetailedMessage(organizationDefectTranslations().eitherPermalinkOrChainCanBeFilled());
    }

    public static DefectType invalidOrganizationStatus(String status) {
        return badStatus().withDetailedMessage(organizationDefectTranslations().invalidOrganizationStatus(status));
    }
}
