package ru.yandex.direct.api.v5.entity.promotedcontent;

import com.yandex.direct.api.v5.promotedcontent.AddTypeEnum;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;

public class PromotedContentDefectTypes {

    private static CommonDefectTranslations commonTranslations() {
        return CommonDefectTranslations.INSTANCE;
    }

    public static DefectType maxContentPerAddRequest(int max) {
        return new DefectType(9300, commonTranslations().maxElementsPerRequestShort())
                .withDetailedMessage((path, value) -> commonTranslations()
                        .maxContentPromotionPerAddRequestDetailed(new Identity(max)));
    }

    public static DefectType maxContentPerAddRequest(int max, AddTypeEnum type) {
        return new DefectType(9300, commonTranslations().maxElementsPerRequestShort())
                .withDetailedMessage((path, value) -> commonTranslations()
                        .maxContentPromotionWithTypePerAddRequestDetailed(new Identity(max), type.name()));
    }

    public static DefectType wrongContentType() {
        return DefectTypes.invalidValue().withDetailedMessage(
                commonTranslations().wrongContentPromotionContentType());
    }
}
