package ru.yandex.direct.api.v5.entity.promotedcontent;

import com.yandex.direct.api.v5.promotedcontent.AddRequest;
import com.yandex.direct.api.v5.promotedcontent.AddResponse;
import com.yandex.direct.api.v5.promotedcontent.GetRequest;
import com.yandex.direct.api.v5.promotedcontent.GetResponse;
import com.yandex.direct.api.v5.promotedcontent.PromotedContentPort;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.common.validation.DefaultApiPresentations;
import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.promotedcontent.delegate.AddContentDelegate;
import ru.yandex.direct.api.v5.entity.promotedcontent.delegate.GetContentDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class PromotedContentEndpoint implements PromotedContentPort {
    public static final DefectPresentationsHolder DEFECT_PRESENTATIONS = DefectPresentationsHolder
            .builderWithFallback(DefaultApiPresentations.HOLDER)
            .build();

    private static final String SERVICE_NAME = "promotedcontent";

    private final GenericApiService genericApiService;
    private final AddContentDelegate addContentDelegate;
    private final GetContentDelegate getContentDelegate;

    @Autowired
    public PromotedContentEndpoint(
            GenericApiService genericApiService,
            AddContentDelegate addContentDelegate,
            GetContentDelegate getContentDelegate) {
        this.genericApiService = genericApiService;
        this.addContentDelegate = addContentDelegate;
        this.getContentDelegate = getContentDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) {
        return genericApiService.doAction(addContentDelegate, addRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) {
        return genericApiService.doAction(getContentDelegate, getRequest);
    }
}

