package ru.yandex.direct.api.v5.entity.promotedcontent.converter;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.promotedcontent.AddTypeEnum;
import com.yandex.direct.api.v5.promotedcontent.GetTypeEnum;

import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;

@ParametersAreNonnullByDefault
public class ContentTypeConverter {
    public static ContentPromotionContentType convertAddTypeToCoreType(@Nullable AddTypeEnum addTypeEnum) {
        if (addTypeEnum == null) {  // валидация на null проиходит далее в validateInternalRequest
            return null;
        }
        switch (addTypeEnum) {
            case VIDEO:
                return ContentPromotionContentType.VIDEO;
            case COLLECTION:
                return ContentPromotionContentType.COLLECTION;
            case SERVICE:
                return ContentPromotionContentType.SERVICE;
            case EDA:
                return ContentPromotionContentType.EDA;
            default:
                throw new IllegalArgumentException("Not supported content promotion type: " + addTypeEnum);
        }
    }

    public static GetTypeEnum convertCoreTypeToGetType(@Nullable ContentPromotionContentType contentType) {
        if (contentType == null) {
            return GetTypeEnum.UNKNOWN;
        }
        switch (contentType) {
            case VIDEO:
                return GetTypeEnum.VIDEO;
            case COLLECTION:
                return GetTypeEnum.COLLECTION;
            case SERVICE:
                return GetTypeEnum.SERVICE;
            case EDA:
                return GetTypeEnum.EDA;
            default:
                return GetTypeEnum.UNKNOWN;
        }
    }
}
