package ru.yandex.direct.api.v5.entity.retargetinglists;

import com.yandex.direct.api.v5.retargetinglists.AddRequest;
import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import com.yandex.direct.api.v5.retargetinglists.ApiException;
import com.yandex.direct.api.v5.retargetinglists.DeleteRequest;
import com.yandex.direct.api.v5.retargetinglists.DeleteResponse;
import com.yandex.direct.api.v5.retargetinglists.GetRequest;
import com.yandex.direct.api.v5.retargetinglists.GetResponse;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListsPort;
import com.yandex.direct.api.v5.retargetinglists.UpdateRequest;
import com.yandex.direct.api.v5.retargetinglists.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.retargetinglists.delegate.AddRetargetingListsDelegate;
import ru.yandex.direct.api.v5.entity.retargetinglists.delegate.DeleteRetargetingListsDelegate;
import ru.yandex.direct.api.v5.entity.retargetinglists.delegate.GetRetargetingListsDelegate;
import ru.yandex.direct.api.v5.entity.retargetinglists.delegate.UpdateRetargetingListsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;


/**
 * Soap service
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class RetargetingListsEndpoint implements RetargetingListsPort {
    private static final String SERVICE_NAME = "retargetinglists";

    private final AddRetargetingListsDelegate addRetargetingListsDelegate;
    private final GetRetargetingListsDelegate getRetargetingListsDelegate;
    private final DeleteRetargetingListsDelegate deleteRetargetingListsDelegate;
    private final UpdateRetargetingListsDelegate updateRetargetingListsDelegate;
    private final GenericApiService genericApiService;

    @Autowired
    public RetargetingListsEndpoint(
            AddRetargetingListsDelegate addRetargetingListsDelegate,
            GetRetargetingListsDelegate getRetargetingListsDelegate,
            DeleteRetargetingListsDelegate deleteRetargetingListsDelegate,
            UpdateRetargetingListsDelegate updateRetargetingListsDelegate,
            GenericApiService genericApiService) {
        this.addRetargetingListsDelegate = addRetargetingListsDelegate;
        this.getRetargetingListsDelegate = getRetargetingListsDelegate;
        this.deleteRetargetingListsDelegate = deleteRetargetingListsDelegate;
        this.updateRetargetingListsDelegate = updateRetargetingListsDelegate;
        this.genericApiService = genericApiService;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getRetargetingListsDelegate, getRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) throws ApiException {
        return genericApiService.doAction(addRetargetingListsDelegate, addRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "update")
    @ApiResponse
    @Override
    public UpdateResponse update(@ApiRequest UpdateRequest updateRequest) throws ApiException {
        return genericApiService.doAction(updateRetargetingListsDelegate, updateRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest deleteRequest) throws ApiException {
        return genericApiService.doAction(deleteRetargetingListsDelegate, deleteRequest);
    }
}
