package ru.yandex.direct.api.v5.entity.retargetinglists.delegate;

import java.util.List;

import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.retargetinglists.AddRequest;
import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.BaseApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.retargetinglists.converter.AddRequestConverter;
import ru.yandex.direct.api.v5.entity.retargetinglists.validation.AddUpdateRequestValidator;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.core.entity.user.model.ApiUser;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
public class AddRetargetingListsDelegate extends
        BaseApiServiceDelegate<AddRequest, AddResponse, List<RetargetingCondition>, ApiResult<Long>> {
    private final RetargetingConditionService retargetingConditionService;
    private final AddRequestConverter addRequestConverter;
    private final ResultConverter resultConverter;

    @Autowired
    public AddRetargetingListsDelegate(ApiAuthenticationSource auth,
                                       RetargetingConditionService retargetingConditionService,
                                       AddRequestConverter addRequestConverter,
                                       ResultConverter resultConverter) {
        super(ApiPathConverter.forRetargetingLists(), auth);
        this.retargetingConditionService = retargetingConditionService;
        this.addRequestConverter = addRequestConverter;
        this.resultConverter = resultConverter;
    }

    @Override
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest externalRequest) {
        return AddUpdateRequestValidator.validateAddRequest(externalRequest);
    }

    @Override
    public List<RetargetingCondition> convertRequest(AddRequest externalRequest) {
        return addRequestConverter.convert(externalRequest);
    }

    @Override
    public ApiMassResult<Long> processRequest(List<RetargetingCondition> internalRequest) {
        ApiUser chiefSubclient = auth.getChiefSubclient();
        ClientId clientId = chiefSubclient.getClientId();
        internalRequest.forEach(rc -> rc.setClientId(clientId.asLong()));
        return resultConverter.toApiMassResult(
                retargetingConditionService.addRetargetingConditions(internalRequest, clientId));
    }

    @Override
    public AddResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        List<ActionResult> addResults = mapList(result.getResult(),
                r -> resultConverter.convertToActionResult(r, apiPathConverter));
        return new AddResponse().withAddResults(addResults);
    }
}
