package ru.yandex.direct.api.v5.entity.retargetinglists.delegate;

import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.UpdateRequest;
import com.yandex.direct.api.v5.retargetinglists.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.BaseApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.retargetinglists.converter.UpdateRequestConverter;
import ru.yandex.direct.api.v5.entity.retargetinglists.validation.AddUpdateRequestValidator;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.user.model.ApiUser;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.stream.Collectors.toList;

@Service
public class UpdateRetargetingListsDelegate extends
        BaseApiServiceDelegate<UpdateRequest, UpdateResponse, List<ModelChanges<RetargetingCondition>>, ApiResult<Long>> {
    private final RetargetingConditionOperationFactory retargetingConditionOperationFactory;
    private final UpdateRequestConverter updateRequestConverter;
    private final ResultConverter resultConverter;

    @Autowired
    public UpdateRetargetingListsDelegate(
            ApiAuthenticationSource auth,
            RetargetingConditionOperationFactory retargetingConditionOperationFactory,
            UpdateRequestConverter updateRequestConverter,
            ResultConverter resultConverter) {
        super(ApiPathConverter.forRetargetingLists(), auth);
        this.retargetingConditionOperationFactory = retargetingConditionOperationFactory;
        this.updateRequestConverter = updateRequestConverter;
        this.resultConverter = resultConverter;
    }

    @Override
    public ValidationResult<UpdateRequest, DefectType> validateRequest(UpdateRequest externalRequest) {
        return AddUpdateRequestValidator.validateUpdateRequest(externalRequest);
    }

    @Override
    public List<ModelChanges<RetargetingCondition>> convertRequest(UpdateRequest externalRequest) {
        return updateRequestConverter.convert(externalRequest);
    }

    @Override
    public ApiMassResult<Long> processRequest(List<ModelChanges<RetargetingCondition>> internalRequest) {
        ApiUser chiefSubclient = auth.getChiefSubclient();
        return resultConverter.toApiMassResult(retargetingConditionOperationFactory.updateRetargetingConditions(
                chiefSubclient.getClientId(),
                internalRequest));
    }

    @Override
    public UpdateResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new UpdateResponse()
                .withUpdateResults(
                        result.getResult()
                                .stream()
                                .map(r -> resultConverter.convertToActionResult(r, apiPathConverter))
                                .collect(toList())
                );
    }
}
