package ru.yandex.direct.api.v5.entity.sitelinks;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.api.v5.entity.sitelinks.Constants.DEFAULT_LIMIT;
import static ru.yandex.direct.api.v5.entity.sitelinks.Constants.DEFAULT_OFFSET;

public class SitelinkSelection implements Model {
    public static final ModelProperty<SitelinkSelection, List<Long>> IDS =
            prop("ids", SitelinkSelection::getIds, SitelinkSelection::setIds);
    public static final ModelProperty<SitelinkSelection, Long> LIMIT =
            prop("limit", SitelinkSelection::getLimit, SitelinkSelection::setLimit);
    public static final ModelProperty<SitelinkSelection, Long> OFFSET =
            prop("offset", SitelinkSelection::getOffset, SitelinkSelection::setOffset);

    private static <V> ModelProperty<SitelinkSelection, V> prop(String name,
                                                                Function<SitelinkSelection, V> getter, BiConsumer<SitelinkSelection, V> setter) {
        return ModelProperty.create(SitelinkSelection.class, name, getter, setter);
    }

    private List<Long> ids;
    private Long limit = DEFAULT_LIMIT;
    private Long offset = DEFAULT_OFFSET;

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Long getLimit() {
        return limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Long getOffset() {
        return offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public SitelinkSelection withIds(List<Long> ids) {
        this.ids = ids;
        return this;
    }

    public SitelinkSelection withLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    public SitelinkSelection withOffset(Long offset) {
        this.offset = offset;
        return this;
    }
}
