package ru.yandex.direct.api.v5.entity.sitelinks;

import java.util.Objects;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;

@SuppressWarnings("unused")
public class SitelinksDefectTypes {
    public static DefectType titlesTogetherTooLong(StringDefectParams t) {
        return DefectTypes.maxStringSize(t.getMaxLength())
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE
                        .maxSitelinkTitlesSizeWithMax(Identity.of(t.getMaxLength())));
    }

    public static DefectType titlesTogetherTooLongFirstBlock(StringDefectParams t) {
        return DefectTypes.maxStringSize(t.getMaxLength())
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE
                        .maxSitelinkTitlesSizeWithMaxFirstBlock(Identity.of(t.getMaxLength())));
    }

    public static DefectType titlesTogetherTooLongSecondBlock(StringDefectParams t) {
        return DefectTypes.maxStringSize(t.getMaxLength())
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE
                        .maxSitelinkTitlesSizeWithMaxSecondBlock(Identity.of(t.getMaxLength())));
    }

    public static DefectType titleTooLong(StringDefectParams t) {
        return DefectTypes.maxStringSize(t.getMaxLength())
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE
                        .sitelinkTitleLengthCannotBeMoreThanMax(Identity.of(t.getMaxLength())));
    }

    public static DefectType descriptionTooLong(StringDefectParams t) {
        return DefectTypes.maxStringSize(t.getMaxLength())
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE
                        .sitelinkDescriptionLengthCannotBeMoreThanMax(Identity.of(t.getMaxLength())));
    }

    public static DefectType hrefTooLong(StringDefectParams t) {
        return DefectTypes.maxStringSize(t.getMaxLength())
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE
                        .sitelinkHrefLengthCannotBeMoreThanMax(Identity.of(t.getMaxLength())));
    }

    public static DefectType disallowedSymbolsInTitle(StringDefectParams t) {
        return DefectTypes.invalidChars()
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE.notAllowedSymbolsInSitelinkTitle());
    }

    public static DefectType disallowedSymbolsInDescription(StringDefectParams t) {
        return DefectTypes.invalidChars()
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE.notAllowedSymbolsInSitelinkDesc());
    }

    public static DefectType emptyTitle(Void t) {
        return DefectTypes.emptyValue()
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE.sitelinkTitleCannotBeEmpty());
    }

    public static DefectType emptyDescription(Void t) {
        return DefectTypes.emptyValue()
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE.sitelinkDescriptionCannotBeEmpty());
    }

    public static DefectType invalidHref(Void t) {
        return DefectTypes.invalidValue().withDetailedMessage(
                (path, value) -> SitelinkDefectTranslations.INSTANCE.invalidSitelinkHref(Objects.toString(value)));
    }

    // Sitelink Sets
    public static DefectType duplicateTitles(Void t) {
        return DefectTypes.duplicatedElement()
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE.duplicateSitelinkTitles());
    }

    public static DefectType duplicateHrefs(Void t) {
        return DefectTypes.duplicatedElement()
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE.duplicateSitelinkHrefs());
    }

    public static DefectType duplicateDescriptions(Void t) {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(SitelinkDefectTranslations.INSTANCE.duplicateSitelinkDescs());
    }

    public static DefectType duplicateObjectsInRequest(Void t) {
        return DefectTypes.duplicatedObject().withDetailedMessage(
                (path, value) -> SitelinkDefectTranslations.INSTANCE.sitelinkSetIdDetailed(Objects.toString(value)));
    }

    public static DefectType invalidSubobjectCount(CollectionSizeDefectParams t) {
        return DefectTypes.invalidCollectionSize(t.getMinSize(), t.getMaxSize()).withDetailedMessage(
                SitelinkDefectTranslations.INSTANCE
                        .sitelinkCountInInterval(Identity.of(t.getMinSize()), Identity.of(t.getMaxSize())));
    }
}
