package ru.yandex.direct.api.v5.entity.sitelinks;

import com.yandex.direct.api.v5.sitelinks.AddRequest;
import com.yandex.direct.api.v5.sitelinks.AddResponse;
import com.yandex.direct.api.v5.sitelinks.ApiException;
import com.yandex.direct.api.v5.sitelinks.DeleteRequest;
import com.yandex.direct.api.v5.sitelinks.DeleteResponse;
import com.yandex.direct.api.v5.sitelinks.GetRequest;
import com.yandex.direct.api.v5.sitelinks.GetResponse;
import com.yandex.direct.api.v5.sitelinks.SitelinksPort;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.sitelinks.delegate.AddSitelinksDelegate;
import ru.yandex.direct.api.v5.entity.sitelinks.delegate.DeleteSitelinksDelegate;
import ru.yandex.direct.api.v5.entity.sitelinks.delegate.GetSitelinksDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.entity.sitelink.model.Sitelink;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.PathConverter;

/**
 * Сервис по работе с наборами быстрых ссылок
 * <p>
 * https://tech.yandex.ru/direct/doc/ref-v5/sitelinks/sitelinks-docpage/
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class SitelinksEndpoint implements SitelinksPort {
    private static final String SERVICE_NAME = "sitelinks";
    public static final PathConverter PATH_CONVERTER =
            MappingPathConverter.builder(SitelinksEndpoint.class, "capitalize")
                    .add(ApiPathConverter.getCommonDict())
                    .add(SitelinkSet.SITELINKS.name(), "Sitelinks")
                    .add(Sitelink.DESCRIPTION.name(), "Description")
                    .add(Sitelink.TITLE.name(), "Title")
                    .add(Sitelink.HREF.name(), "Href")
                    .add(Sitelink.TURBO_LANDING_ID.name(), "TurboPageId")
                    .build();

    private final GenericApiService genericApiService;
    private final AddSitelinksDelegate addDelegate;
    private final GetSitelinksDelegate getDelegate;
    private final DeleteSitelinksDelegate deleteDelegate;

    @Autowired
    public SitelinksEndpoint(
            GenericApiService genericApiService,
            AddSitelinksDelegate addDelegate,
            GetSitelinksDelegate getDelegate,
            DeleteSitelinksDelegate deleteDelegate) {
        this.genericApiService = genericApiService;
        this.addDelegate = addDelegate;
        this.getDelegate = getDelegate;
        this.deleteDelegate = deleteDelegate;
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) throws ApiException {
        return genericApiService.doAction(addDelegate, addRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getDelegate, getRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest deleteRequest) throws ApiException {
        return genericApiService.doAction(deleteDelegate, deleteRequest);
    }
}
