package ru.yandex.direct.api.v5.entity.sitelinks.converter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.general.IdsCriteria;
import com.yandex.direct.api.v5.sitelinks.DeleteRequest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;


@Component
@ParametersAreNonnullByDefault
public class DeleteRequestConverter implements Converter<DeleteRequest, List<Long>> {

    @Override
    public List<Long> convert(DeleteRequest deleteRequest) {
        IdsCriteria criteria = deleteRequest.getSelectionCriteria();

        return Optional.ofNullable(criteria)
                .map(IdsCriteria::getIds)
                .orElseGet(Collections::emptyList);
    }

}
