package ru.yandex.direct.api.v5.entity.sitelinks.delegate;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.sitelinks.SitelinkFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import one.util.streamex.StreamEx;

@ParametersAreNonnullByDefault
public enum SitelinkAnyFieldEnum {
    ID(SitelinksSetFieldEnum.class, SitelinksSetFieldEnum.ID),
    SITELINKS(SitelinksSetFieldEnum.class, SitelinksSetFieldEnum.SITELINKS),

    HREF(SitelinkFieldEnum.class, SitelinkFieldEnum.HREF),
    DESCRIPTION(SitelinkFieldEnum.class, SitelinkFieldEnum.DESCRIPTION),
    TITLE(SitelinkFieldEnum.class, SitelinkFieldEnum.TITLE),
    TURBO_PAGE_ID(SitelinkFieldEnum.class, SitelinkFieldEnum.TURBO_PAGE_ID);

    private final Class<?> enumClazz;
    private final Enum value;

    private static final Map<Enum, SitelinkAnyFieldEnum> FIELD_ENUM =
            StreamEx.of(SitelinkAnyFieldEnum.values()).toMap(SitelinkAnyFieldEnum::getValue, Function.identity());

    SitelinkAnyFieldEnum(Class<?> enumClazz, Enum value) {
        this.enumClazz = enumClazz;
        this.value = value;
    }

    public Class<?> getEnumClass() {
        return enumClazz;
    }

    public Enum getValue() {
        return value;
    }


    private static SitelinkAnyFieldEnum fromEnum(Enum enumValue) {
        return Optional.ofNullable(FIELD_ENUM.get(enumValue)).orElseThrow(IllegalArgumentException::new);
    }

    public static SitelinkAnyFieldEnum fromSitelinkFieldEnum(SitelinkFieldEnum sitelinkFieldEnum) {
        return fromEnum(sitelinkFieldEnum);
    }

    public static SitelinkAnyFieldEnum fromSitelinksSetFieldEnum(SitelinksSetFieldEnum sitelinksSetFieldEnum) {
        return fromEnum(sitelinksSetFieldEnum);
    }
}

