package ru.yandex.direct.api.v5.entity.smartadtargets;

import com.yandex.direct.api.v5.smartadtargets.AddRequest;
import com.yandex.direct.api.v5.smartadtargets.AddResponse;
import com.yandex.direct.api.v5.smartadtargets.ApiException;
import com.yandex.direct.api.v5.smartadtargets.DeleteRequest;
import com.yandex.direct.api.v5.smartadtargets.DeleteResponse;
import com.yandex.direct.api.v5.smartadtargets.GetRequest;
import com.yandex.direct.api.v5.smartadtargets.GetResponse;
import com.yandex.direct.api.v5.smartadtargets.ResumeRequest;
import com.yandex.direct.api.v5.smartadtargets.ResumeResponse;
import com.yandex.direct.api.v5.smartadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.smartadtargets.SetBidsResponse;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetsPort;
import com.yandex.direct.api.v5.smartadtargets.SuspendRequest;
import com.yandex.direct.api.v5.smartadtargets.SuspendResponse;
import com.yandex.direct.api.v5.smartadtargets.UpdateRequest;
import com.yandex.direct.api.v5.smartadtargets.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.smartadtargets.delegate.AddSmartAdTargetDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.delegate.DeleteSmartAdTargetDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.delegate.GetSmartAdTargetDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.delegate.ResumeSmartAdTargetDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.delegate.SetBidsSmartAdTargetDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.delegate.SuspendSmartAdTargetDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.delegate.UpdateSmartAdTargetDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class SmartAdTargetEndpoint implements SmartAdTargetsPort {

    private static final String SERVICE_NAME = "smartadtargets";

    private final GenericApiService genericApiService;
    private final GetSmartAdTargetDelegate getSmartAdTargetDelegate;
    private final AddSmartAdTargetDelegate addSmartAdTargetDelegate;
    private final UpdateSmartAdTargetDelegate updateSmartAdTargetDelegate;
    private final SuspendSmartAdTargetDelegate suspendSmartAdTargetDelegate;
    private final ResumeSmartAdTargetDelegate resumeSmartAdTargetDelegate;
    private final DeleteSmartAdTargetDelegate deleteSmartAdTargetDelegate;
    private final SetBidsSmartAdTargetDelegate setBidsSmartAdTargetDelegate;

    @Autowired
    public SmartAdTargetEndpoint(GenericApiService genericApiService,
                                 GetSmartAdTargetDelegate getSmartAdTargetDelegate,
                                 AddSmartAdTargetDelegate addSmartAdTargetDelegate,
                                 UpdateSmartAdTargetDelegate updateSmartAdTargetDelegate,
                                 SuspendSmartAdTargetDelegate suspendSmartAdTargetDelegate,
                                 ResumeSmartAdTargetDelegate resumeSmartAdTargetDelegate,
                                 DeleteSmartAdTargetDelegate deleteSmartAdTargetDelegate,
                                 SetBidsSmartAdTargetDelegate setBidsSmartAdTargetDelegate) {
        this.genericApiService = genericApiService;
        this.getSmartAdTargetDelegate = getSmartAdTargetDelegate;
        this.addSmartAdTargetDelegate = addSmartAdTargetDelegate;
        this.updateSmartAdTargetDelegate = updateSmartAdTargetDelegate;
        this.suspendSmartAdTargetDelegate = suspendSmartAdTargetDelegate;
        this.resumeSmartAdTargetDelegate = resumeSmartAdTargetDelegate;
        this.deleteSmartAdTargetDelegate = deleteSmartAdTargetDelegate;
        this.setBidsSmartAdTargetDelegate = setBidsSmartAdTargetDelegate;
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) {
        return genericApiService.doAction(addSmartAdTargetDelegate, addRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getSmartAdTargetDelegate, getRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "update")
    @ApiResponse
    @Override
    public UpdateResponse update(@ApiRequest UpdateRequest updateRequest) {
        return genericApiService.doAction(updateSmartAdTargetDelegate, updateRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest deleteRequest) {
        return genericApiService.doAction(deleteSmartAdTargetDelegate, deleteRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "suspend")
    @ApiResponse
    @Override
    public SuspendResponse suspend(@ApiRequest SuspendRequest suspendRequest) {
        return genericApiService.doAction(suspendSmartAdTargetDelegate, suspendRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "resume")
    @ApiResponse
    @Override
    public ResumeResponse resume(@ApiRequest ResumeRequest resumeRequest) {
        return genericApiService.doAction(resumeSmartAdTargetDelegate, resumeRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "setBids")
    @ApiResponse
    @Override
    public SetBidsResponse setBids(@ApiRequest SetBidsRequest setBidsRequest) {
        return genericApiService.doAction(setBidsSmartAdTargetDelegate, setBidsRequest);
    }

}
