package ru.yandex.direct.api.v5.entity.smartadtargets;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.i18n.types.Identity;

public class SmartAdTargetsDefectTypes {
    private SmartAdTargetsDefectTypes() {
    }

    private static SmartAdTargetsDefectTranslations translations() {
        return SmartAdTargetsDefectTranslations.INSTANCE;
    }

    public static DefectType maxElementsPerRequest(int maxElements) {
        return DefectTypes.maxIdsInSelection()
                .withDetailedMessage(translations().maxElementsPerRequest(new Identity(maxElements)));
    }

    public static DefectType maxIdsCountPerRequest(int maxIdCount) {
        return DefectTypes.maxIdsInSelection()
                .withDetailedMessage(translations().maxIdsCountPerRequest(new Identity(maxIdCount)));
    }

    public static DefectType inconsistentAdGroupType() {
        return DefectTypes.maxIdsInSelection()
                .withDetailedMessage(translations().inconsistentAdGroupType());
    }

}
