package ru.yandex.direct.api.v5.entity.smartadtargets.converter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum;
import com.yandex.direct.api.v5.general.AdTargetsSelectionCriteria;
import com.yandex.direct.api.v5.smartadtargets.GetRequest;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetFieldEnum;

import ru.yandex.direct.core.entity.performancefilter.container.PerformanceFilterSelectionCriteria;

import static com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum.DELETED;
import static com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum.OFF;
import static com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum.ON;
import static com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum.SUSPENDED;
import static org.apache.commons.collections4.CollectionUtils.isEmpty;

public class GetRequestConverter {
    private static final Set<SmartAdTargetFieldEnum> DEFAULT_FIELD_NAMES = Set.of(SmartAdTargetFieldEnum.ID);

    private GetRequestConverter() {
    }

    public static PerformanceFilterSelectionCriteria convert(GetRequest getRequest) {
        AdTargetsSelectionCriteria src = getRequest.getSelectionCriteria();
        HashSet<AdTargetStateSelectionEnum> statuses = new HashSet<>(src.getStates());
        PerformanceFilterSelectionCriteria selectionCriteria = new PerformanceFilterSelectionCriteria()
                .withPerfFilterIds(src.getIds())
                .withAdGroupIds(src.getAdGroupIds())
                .withCampaignIds(src.getCampaignIds());
        if (!statuses.contains(DELETED)) {
            selectionCriteria.withoutDeleted();
        }
        if (!statuses.isEmpty() && !statuses.contains(SUSPENDED) && !statuses.contains(OFF)) {
            selectionCriteria.withoutSuspended();
            selectionCriteria.withoutNotSynced();
        }
        if (!statuses.isEmpty() && !statuses.contains(SUSPENDED) && !statuses.contains(ON)) {
            selectionCriteria.withoutSynced();
        }
        return selectionCriteria;
    }

    public static Set<SmartAdTargetFieldEnum> getSmartAdTargetFieldEnums(GetRequest externalRequest) {
        List<SmartAdTargetFieldEnum> fieldNames = externalRequest.getFieldNames();
        if (isEmpty(fieldNames)) {
            return DEFAULT_FIELD_NAMES;
        }
        return new HashSet<>(fieldNames);
    }

}
