package ru.yandex.direct.api.v5.entity.smartadtargets.defects;

import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterDefects.PerformanceFilterDefectIds;

import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTranslations.TRANSLATIONS;

public class SmartAdTargetDefectTypes {

    public static final DefectPresentationsHolder DEFECT_PRESENTATIONS = DefectPresentationsHolder.builder()
            .register(PerformanceFilterDefectIds.FILTER_CONDITIONS_IS_TOO_LONG, t -> filterConditionsIsTooLong())
            .register(PerformanceFilterDefectIds.INCONSISTENT_CAMPAIGN_STRATEGY, t -> inconsistentCampaignStrategy())
            .register(PerformanceFilterDefectIds.INVALID_OPERATOR, t -> invalidOperator())
            .register(PerformanceFilterDefectIds.MUST_CONTAIN_ANY_MORE_CONDITIONS, t -> mustContainAnyMoreConditions())
            .register(PerformanceFilterDefectIds.UNKNOWN_FIELD, t -> unknownField())
            .register(PerformanceFilterDefectIds.UNKNOWN_OPERATOR, t -> unknownOperator())
            .build();

    private SmartAdTargetDefectTypes() {
    }

    public static DefectType mustContainAnyMoreConditions() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(TRANSLATIONS.mustContainAnyMoreConditions());
    }

    public static DefectType filterConditionsIsTooLong() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(TRANSLATIONS.filterConditionsIsTooLong());
    }

    public static DefectType inconsistentCampaignStrategy() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(TRANSLATIONS.inconsistentCampaignStrategy());
    }

    public static DefectType invalidOperator() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(TRANSLATIONS.invalidOperator());
    }

    public static DefectType unknownField() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(TRANSLATIONS.unknownField());
    }

    public static DefectType unknownOperator() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(TRANSLATIONS.unknownOperator());
    }

}
