package ru.yandex.direct.api.v5.entity.smartadtargets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.smartadtargets.AddRequest;
import com.yandex.direct.api.v5.smartadtargets.AddResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.converter.AddRequestConverterService;
import ru.yandex.direct.api.v5.entity.smartadtargets.validation.SmartAdTargetValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilter;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterService;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFiltersAddOperation;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.DEFECT_PRESENTATIONS;

@Service
@ParametersAreNonnullByDefault
public class AddSmartAdTargetDelegate
        extends OperationOnListDelegate<AddRequest, AddResponse, PerformanceFilter, Long> {

    private final SmartAdTargetValidationService validationService;
    private final PerformanceFilterService performanceFilterService;
    private final AddRequestConverterService requestConverterService;
    private final ResultConverter resultConverter;

    @Autowired
    public AddSmartAdTargetDelegate(ApiAuthenticationSource apiAuthenticationSource,
                                    SmartAdTargetValidationService validationService,
                                    PerformanceFilterService performanceFilterService,
                                    AddRequestConverterService requestConverterService,
                                    ResultConverter resultConverter,
                                    PpcPropertiesSupport ppcPropertiesSupport,
                                    FeatureService featureService) {
        super(ApiPathConverter.forSmartadtargets(), apiAuthenticationSource, ppcPropertiesSupport, featureService);
        this.validationService = validationService;
        this.performanceFilterService = performanceFilterService;
        this.requestConverterService = requestConverterService;
        this.resultConverter = resultConverter;
    }

    @Nullable
    @Override
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest addRequest) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        return validationService.validateAddRequest(clientId, addRequest);
    }

    @Override
    public List<PerformanceFilter> convertRequest(AddRequest externalRequest) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        return requestConverterService.convertItemsToModels(clientId, externalRequest.getSmartAdTargets());
    }

    @Override
    public ApiMassResult<Long> processList(List<PerformanceFilter> performanceFiltersToAdd) {
        Long operatorUid = auth.getOperator().getUid();
        ClientId clientId = auth.getChiefSubclient().getClientId();
        PerformanceFiltersAddOperation addOperation =
                performanceFilterService.createPartialAddOperation(clientId, operatorUid, performanceFiltersToAdd);
        MassResult<Long> idsMassResult = addOperation.prepareAndApply();
        return resultConverter.toApiMassResult(idsMassResult, DEFECT_PRESENTATIONS);
    }

    @Override
    public AddResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new AddResponse().withAddResults(resultConverter.toActionResults(result, apiPathConverter));
    }

}
