package ru.yandex.direct.api.v5.entity.smartadtargets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.smartadtargets.DeleteRequest;
import com.yandex.direct.api.v5.smartadtargets.DeleteResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.validation.SmartAdTargetValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.DEFECT_PRESENTATIONS;

@Service
@ParametersAreNonnullByDefault
public class DeleteSmartAdTargetDelegate
        extends OperationOnListDelegate<DeleteRequest, DeleteResponse, Long, Long> {

    private final SmartAdTargetValidationService validationService;
    private final PerformanceFilterService performanceFilterService;
    private final ResultConverter resultConverter;

    @Autowired
    public DeleteSmartAdTargetDelegate(ApiAuthenticationSource apiAuthenticationSource,
                                       SmartAdTargetValidationService validationService,
                                       PerformanceFilterService performanceFilterService,
                                       ResultConverter resultConverter,
                                       PpcPropertiesSupport ppcPropertiesSupport,
                                       FeatureService featureService) {
        super(ApiPathConverter.forSmartadtargets(), apiAuthenticationSource, ppcPropertiesSupport, featureService);
        this.validationService = validationService;
        this.performanceFilterService = performanceFilterService;
        this.resultConverter = resultConverter;
    }

    @Nullable
    @Override
    public ValidationResult<DeleteRequest, DefectType> validateRequest(DeleteRequest deleteRequest) {
        return validationService.validateDeleteRequest(deleteRequest);
    }

    @Override
    public List<Long> convertRequest(DeleteRequest externalRequest) {
        return externalRequest.getSelectionCriteria().getIds();
    }

    @Override
    public ApiMassResult<Long> processList(List<Long> performanceFilterIds) {
        Long operatorUid = auth.getOperator().getUid();
        ClientId clientId = auth.getChiefSubclient().getClientId();
        MassResult<Long> idsMassResult =
                performanceFilterService.deletePerformanceFilters(clientId, operatorUid, performanceFilterIds);
        return resultConverter.toApiMassResult(idsMassResult, DEFECT_PRESENTATIONS);
    }

    @Override
    public DeleteResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new DeleteResponse().withDeleteResults((resultConverter.toActionResults(result, apiPathConverter)));
    }

}
