package ru.yandex.direct.api.v5.entity.smartadtargets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.general.SetBidsActionResult;
import com.yandex.direct.api.v5.smartadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.smartadtargets.SetBidsResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.smartadtargets.converter.RequestConverter;
import ru.yandex.direct.api.v5.entity.smartadtargets.validation.SetBidsValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.bids.container.SetBidItem;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterSetBidsService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.DEFECT_PRESENTATIONS;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class SetBidsSmartAdTargetDelegate
        extends OperationOnListDelegate<SetBidsRequest, SetBidsResponse, SetBidItem, SetBidItem> {

    private final SetBidsValidationService validationService;
    private final RequestConverter requestConverter;
    private final PerformanceFilterSetBidsService performanceFilterSetBidsService;
    private final ResultConverter resultConverter;

    @Autowired
    public SetBidsSmartAdTargetDelegate(ApiAuthenticationSource apiAuthenticationSource,
                                        SetBidsValidationService validationService,
                                        PerformanceFilterSetBidsService performanceFilterSetBidsService,
                                        RequestConverter requestConverter,
                                        ResultConverter resultConverter,
                                        PpcPropertiesSupport ppcPropertiesSupport,
                                        FeatureService featureService) {
        super(ApiPathConverter.forSmartadtargetsSetBidsPathConverter(), apiAuthenticationSource, ppcPropertiesSupport, featureService);
        this.validationService = validationService;
        this.performanceFilterSetBidsService = performanceFilterSetBidsService;
        this.resultConverter = resultConverter;
        this.requestConverter = requestConverter;
    }

    @Nullable
    @Override
    public ValidationResult<SetBidsRequest, DefectType> validateRequest(SetBidsRequest setBidsRequest) {
        return validationService.validate(setBidsRequest);
    }

    @Override
    public List<SetBidItem> convertRequest(SetBidsRequest setBidsRequest) {
        return requestConverter.convertSetBidsRequest(setBidsRequest);
    }

    @Override
    public ApiMassResult<SetBidItem> processList(List<SetBidItem> validItems) {
        Long operatorUid = auth.getOperator().getUid();
        ClientId clientId = auth.getChiefSubclient().getClientId();
        MassResult<SetBidItem> idsMassResult = performanceFilterSetBidsService.setBids(clientId, operatorUid, validItems);
        return resultConverter.toApiMassResult(idsMassResult, DEFECT_PRESENTATIONS);
    }

    @Override
    public SetBidsResponse convertResponse(ApiResult<List<ApiResult<SetBidItem>>> result) {
        List<SetBidsActionResult> setBidsActionResults =
                mapList(result.getResult(), r -> resultConverter.convertToSetBidsActionResult(r, apiPathConverter));
        return new SetBidsResponse().withSetBidsResults(setBidsActionResults);
    }

}
