package ru.yandex.direct.api.v5.entity.turbopages;

import java.util.Map;

import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;

import static org.springframework.beans.BeanUtils.copyProperties;

public class TurboLandingContainer extends TurboLanding {
    private String boundHref;

    public TurboLandingContainer(Map.Entry<String, TurboLanding> turboLandingEntry) {
        copyProperties(turboLandingEntry.getValue(), this);
        this.boundHref = turboLandingEntry.getKey();
    }

    public TurboLandingContainer(TurboLanding turboLanding) {
        copyProperties(turboLanding, this);
    }

    public String getBoundHref() {
        return boundHref;
    }

    public void setBoundHref(String boundHref) {
        this.boundHref = boundHref;
    }
}
