package ru.yandex.direct.api.v5.entity.turbopages;

import com.yandex.direct.api.v5.turbopages.ApiException;
import com.yandex.direct.api.v5.turbopages.GetRequest;
import com.yandex.direct.api.v5.turbopages.GetResponse;
import com.yandex.direct.api.v5.turbopages.TurboPagesPort;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.turbopages.delegate.GetTurboPagesDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.PathConverter;

/**
 * Сервис по работе с турболендингами
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class TurboPagesEndpoint implements TurboPagesPort {
    private static final String SERVICE_NAME = "turbopages";
    public static final PathConverter PATH_CONVERTER =
            MappingPathConverter.builder(TurboPagesEndpoint.class, "capitalize")
                    .add(ApiPathConverter.getCommonDict())
                    .add(TurboLanding.ID.name(), "Id")
                    .add(TurboLanding.NAME.name(), "Name")
                    .add(TurboLanding.URL.name(), "Href")
                    .add(TurboLanding.PREVIEW_HREF.name(), "PreviewHref")
                    .build();

    private final GenericApiService genericApiService;
    private final GetTurboPagesDelegate getDelegate;

    @Autowired
    public TurboPagesEndpoint(GenericApiService genericApiService,
            GetTurboPagesDelegate getDelegate) {
        this.genericApiService = genericApiService;
        this.getDelegate = getDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getDelegate, getRequest);
    }
}
