package ru.yandex.direct.api.v5.entity.vcards;

import java.util.Objects;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.vcard.VcardDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;

public final class VCardDefectTypes {
    private VCardDefectTypes() {
    }

    private static CommonDefectTranslations commonTranslations() {
        return CommonDefectTranslations.INSTANCE;
    }

    private static VcardDefectTranslations translations() {
        return VcardDefectTranslations.INSTANCE;
    }

    // TODO: Перенести потом в более общий класс
    public static DefectType invalidValue() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(
                        (p, v) -> commonTranslations().invalidValueWithOnlyPathDetailed(p));
    }

    public static DefectType campaignNotFound() {
        return DefectTypes.notFound()
                .withDetailedMessage(
                        (p, v) -> translations().campaignNotFound(v.toString()));
    }

    public static DefectType archivedCampaignModification() {
        return DefectTypes.badStatus()
                .withDetailedMessage((p, v) -> translations().archivedCampaignModification(v.toString()));
    }

    // Phone.CountryCode
    public static DefectType phoneCountryCodeIsNullOrEmpty() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(translations().phoneCountryCodeIsNullOrEmpty());
    }

    public static DefectType countryCodeMustStartWithPlus() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().countryCodeMustStartWithPlus());
    }

    public static DefectType countryCodeMustNotStartWithPlus(String cityCode) {
        return DefectTypes.invalidFormat()
                .withDetailedMessage((p, v) -> translations().countryCodeMustNotStartWithPlus(
                        ((String) v).substring(1), // Удаляем '+'
                        cityCode));
    }

    public static DefectType invalidCountryCodeFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().invalidCountryCodeFormat());
    }

    // Phone.CityCode
    public static DefectType phoneCityCodeIsNullOrEmpty() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(translations().phoneCityCodeIsNullOrEmpty());
    }

    public static DefectType invalidPhoneCityCodeFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().invalidPhoneCityCodeFormat());
    }

    // Phone.Number
    public static DefectType phoneNumberIsNullOrEmpty() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(translations().phoneNumberIsNullOrEmpty());
    }

    // Phone.Extension
    public static DefectType invalidPhoneExtensionFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().invalidPhoneExtensionFormat());
    }

    public static DefectType invalidPhoneFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().invalidPhoneNumberFormat());
    }

    // ContactEmail
    public static DefectType invalidContactEmailFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage((p, v) -> translations().invalidContactEmailFormat(p));
    }

    public static DefectType metroCityIsRequired() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(translations().metroCityIsRequired());
    }

    public static DefectType invalidMetro() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(translations().invalidMetro());
    }


    public static DefectType invalidIcqLoginFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().invalidIcqLoginFormat());
    }

    public static DefectType invalidMailAgentLoginFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().invalidMailAgentLoginFormat());
    }

    public static DefectType invalidJabberLoginFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().invalidJabberLoginFormat());
    }

    public static DefectType invalidSkypeOrMsnLoginFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(translations().invalidSkypeOrLoginFormat());
    }


    public static DefectType invalidWorktimeTimeFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage((p, v) -> translations().invalidWorktimeTimeFormat(p));
    }

    public static DefectType worktimeMinuteNotDivisibleBy15() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage((p, v) -> translations().worktimeMinuteNotDivisibleBy15(p));
    }

    public static DefectType worktimeDaysDuplicated() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage((p, v) -> translations().worktimeDaysDuplicated(p));
    }

    public static DefectType vcardIsDuplicated() {
        return new DefectType(10100, translations().vcardIsDuplicated());
    }

    public static DefectType vcardIsInUse() {
        return DefectTypes.inconsistentState().withDetailedMessage(translations().vcardIsInUse());
    }

    public static DefectType vcardIsDuplicatedDelete() {
        return DefectTypes.duplicatedObject()
                .withDetailedMessage((path, value) -> translations().vcardId(Objects.toString(value)));
    }
}
