package ru.yandex.direct.api.v5.entity.vcards.converter;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.vcards.ObjectFactory;
import com.yandex.direct.api.v5.vcards.VCardGetItem;

import ru.yandex.direct.core.entity.vcard.model.InstantMessenger;
import ru.yandex.direct.core.entity.vcard.model.Phone;
import ru.yandex.direct.core.entity.vcard.model.PointOnMap;
import ru.yandex.direct.core.entity.vcard.model.Vcard;

@ParametersAreNonnullByDefault
public class VCardConverter {
    private static final ObjectFactory FACTORY = new ObjectFactory();

    public VCardGetItem convert(Vcard vcard) {
        return FACTORY.createVCardGetItem()
                .withId(vcard.getId())
                .withCampaignId(vcard.getCampaignId())
                .withCompanyName(FACTORY.createVCardGetItemCompanyName(vcard.getCompanyName()))
                .withOgrn(FACTORY.createVCardGetItemOgrn(vcard.getOgrn()))
                .withWorkTime(vcard.getWorkTime() != null ? vcard.getWorkTime().replace("#", ";") : null)
                .withPhone(convertPhone(vcard.getPhone()))
                .withContactPerson(FACTORY.createVCardGetItemContactPerson(vcard.getContactPerson()))
                .withContactEmail(FACTORY.createVCardGetItemContactEmail(vcard.getEmail()))
                .withInstantMessenger(FACTORY.createVCardGetItemInstantMessenger(
                        convertInstantMessenger(vcard.getInstantMessenger())))
                .withCountry(vcard.getCountry())
                .withCity(vcard.getCity())
                .withMetroStationId(FACTORY.createVCardGetItemMetroStationId(vcard.getMetroId()))
                .withStreet(FACTORY.createVCardGetItemStreet(vcard.getStreet()))
                .withHouse(FACTORY.createVCardGetItemHouse(vcard.getHouse()))
                .withBuilding(FACTORY.createVCardGetItemBuilding(vcard.getBuild()))
                .withApartment(FACTORY.createVCardGetItemApartment(vcard.getApart()))
                .withPointOnMap(FACTORY.createVCardGetItemPointOnMap(convertPoinOnMap(
                        vcard.getManualPoint() != null ? vcard.getManualPoint() : vcard.getAutoPoint())))
                .withExtraMessage(FACTORY.createVCardGetItemExtraMessage(vcard.getExtraMessage()));
    }

    private static com.yandex.direct.api.v5.vcards.Phone convertPhone(@Nullable Phone vcardPhone) {
        com.yandex.direct.api.v5.vcards.Phone phone = FACTORY.createPhone();

        if (vcardPhone != null) {
            phone.withCountryCode(vcardPhone.getCountryCode())
                    .withCityCode(vcardPhone.getCityCode())
                    .withPhoneNumber(vcardPhone.getPhoneNumber())
                    .withExtension(vcardPhone.getExtension());
        }

        return phone;
    }

    private static com.yandex.direct.api.v5.vcards.InstantMessenger convertInstantMessenger(
            @Nullable InstantMessenger vcardInstantMessenger) {
        if (vcardInstantMessenger == null) {
            return null;
        }

        return FACTORY.createInstantMessenger()
                .withMessengerClient(vcardInstantMessenger.getType())
                .withMessengerLogin(vcardInstantMessenger.getLogin());
    }

    private static com.yandex.direct.api.v5.vcards.MapPoint convertPoinOnMap(@Nullable PointOnMap vcardPointOnMap) {
        if (vcardPointOnMap == null) {
            return null;
        }

        return FACTORY.createMapPoint()
                .withX(vcardPointOnMap.getX())
                .withX1(vcardPointOnMap.getX1())
                .withX2(vcardPointOnMap.getX2())
                .withY(vcardPointOnMap.getY())
                .withY1(vcardPointOnMap.getY1())
                .withY2(vcardPointOnMap.getY2());
    }
}
