package ru.yandex.direct.api.v5.entity.vcards.delegate;

import java.util.List;

import com.yandex.direct.api.v5.vcards.DeleteRequest;
import com.yandex.direct.api.v5.vcards.DeleteResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.BaseApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.vcards.VCardDefectTypes;
import ru.yandex.direct.api.v5.entity.vcards.VCardsEndpoint;
import ru.yandex.direct.api.v5.entity.vcards.validation.DeleteRequestValidator;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Удалить визитные карточки
 * <p>
 * https://tech.yandex.ru/direct/doc/ref-v5/vcards/delete-docpage/
 */
@Component
public class DeleteVCardsDelegate
        extends BaseApiServiceDelegate<DeleteRequest, DeleteResponse, List<Long>, ApiResult<Long>> {
    public static final DefectPresentationsHolder DELETE_VCARDS_DEFECT_PRESENTATIONS =
            DefectPresentationsHolder.builder()
                    .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS,
                            VCardDefectTypes.vcardIsDuplicatedDelete())
                    .build();

    private final DeleteRequestValidator deleteRequestValidator;
    private final ResultConverter resultConverter;
    private final VcardService vcardService;

    @Autowired
    public DeleteVCardsDelegate(ApiAuthenticationSource auth,
                                DeleteRequestValidator deleteRequestValidator,
                                ResultConverter resultConverter, VcardService vcardService) {
        super(VCardsEndpoint.PATH_CONVERTER, auth);
        this.deleteRequestValidator = deleteRequestValidator;
        this.resultConverter = resultConverter;
        this.vcardService = vcardService;
    }

    @Override
    public ValidationResult<DeleteRequest, DefectType> validateRequest(DeleteRequest externalRequest) {
        return deleteRequestValidator.validateRequest(externalRequest);
    }

    @Override
    public List<Long> convertRequest(DeleteRequest externalRequest) {
        return externalRequest.getSelectionCriteria().getIds();
    }

    @Override
    public ApiMassResult<Long> processRequest(List<Long> internalRequest) {
        MassResult<Long> result = vcardService.deleteVcards(
                internalRequest, auth.getOperator().getUid(),
                auth.getSubclient().getClientId());
        return resultConverter.toApiMassResult(result, DELETE_VCARDS_DEFECT_PRESENTATIONS);
    }

    @Override
    public DeleteResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new DeleteResponse()
                .withDeleteResults(resultConverter.toActionResults(result, apiPathConverter));
    }
}
