package ru.yandex.direct.api.v5.exeptiontranslator;

import javax.xml.ws.WebFault;

import com.yandex.direct.api.v5.general.ApiExceptionMessage;

/**
 * This class represents API exception that can be thrown by web service.
 * <p>
 * It is equal to {@code ApiException} of the each service.
 * <p>
 * There is a problem that each API service has its own representation of error. Though these representations
 * are equal, we can't use random one of them.
 */
@WebFault(name = "FaultResponse", targetNamespace = "http://api.direct.yandex.com/v5/general")
public class ApiWebFaultException extends Exception {
    private final ApiExceptionMessage faultInfo;

    public ApiWebFaultException(String message, ApiExceptionMessage faultInfo) {
        super(message);
        this.faultInfo = faultInfo;
    }

    /**
     * Используется при формировании fault-сообщения клиенту в процессе обработки ошибок в сервисе
     * <p>
     * Доступ к методу осуществляется через reflection
     *
     * @see ru.yandex.direct.api.v5.ws.exceptionresolver.ApiExceptionResolver#getFaultInfoBean(Exception)
     */
    public ApiExceptionMessage getFaultInfo() {
        return faultInfo;
    }
}
