package ru.yandex.direct.api.v5.exeptiontranslator;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.ApiErrorCodes;
import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.api.v5.ws.exceptionresolver.ExceptionTranslator;
import ru.yandex.direct.common.TranslationService;

@Component
@Order(ExceptionTranslator.DEFAULT_TRANSLATOR_ORDER)
public class DefaultExceptionTranslator extends AbstractApiExceptionTranslator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionTranslator.class);

    @Autowired
    public DefaultExceptionTranslator(TranslationService translationService) {
        super(translationService);
    }

    @Override
    public Optional<ApiWebFaultException> translate(Exception ex) {
        logger.error("Unexpected exception", ex);
        return Optional.of(
                createFault(
                        ApiErrorCodes.SERVICE_UNAVAILABLE,
                        ApiFaultTranslations.INSTANCE.serviceUnavailable()));
    }
}
