package ru.yandex.direct.api.v5.exeptiontranslator;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.ws.exceptionresolver.ExceptionTranslator;
import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.TranslatableException;

@Component
@Order(ExceptionTranslator.NON_DEFAULT_TRANSLATOR_ORDER)
public class TranslatableExceptionTranslator extends AbstractApiExceptionTranslator {
    @Autowired
    public TranslatableExceptionTranslator(TranslationService translationService) {
        super(translationService);
    }

    @Override
    public Optional<ApiWebFaultException> translate(Exception ex) {
        if (!(ex instanceof TranslatableException)) {
            return Optional.empty();
        }

        TranslatableException te = (TranslatableException) ex;
        if (te.getDetailedMessage() != null) {
            return Optional.of(createFault(te.getCode(), te.getShortMessage(), te.getDetailedMessage()));
        } else {
            return Optional.of(createFault(te.getCode(), te.getShortMessage()));
        }
    }
}
