package ru.yandex.direct.api.v5.logging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * Логгирование запросов, приходящих в API в файл
 * Логгер полагается на то, что объект {@link ApiLogRecord} хорошо и правильно размечен jackson-аннотациями
 */
@Component
class FileLogger implements ApiLogger {
    private static final Logger logger = LoggerFactory.getLogger(FileLogger.class);
    private static final Logger dataLogger = LoggerFactory.getLogger("LOGAPI.data");
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void log(ApiLogRecord rec) {
        try {
            dataLogger.info("{} {}", rec.getLogTimeString(), objectMapper.writeValueAsString(rec));
        } catch (JsonProcessingException e) {
            logger.error("Can't write log record", e);
        }
    }
}
