package ru.yandex.direct.api.v5.security;

import javax.annotation.Nonnull;

import ru.yandex.direct.api.v5.security.internal.DirectApiInternalAuthRequest;

public interface ApiAuthenticationManager {
    /**
     * Первый шаг аутентификации -- получить информацию об операторе по токену и данных из запроса, и выполнить
     * предварительные проверки возможности пользовать API для этого оператора
     */
    @Nonnull
    DirectApiPreAuthentication checkApiAccessAllowed(DirectApiInternalAuthRequest authRequest);

    /**
     * Второй шаг аутентификации -- определение целевого пользователя и предварительные проверки возможности
     * работать с ним через API
     */
    @Nonnull
    DirectApiPreAuthentication checkClientLoginAccess(DirectApiPreAuthentication authenticationCarrier);
}
