package ru.yandex.direct.api.v5.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;

import ru.yandex.direct.api.v5.context.ApiContext;
import ru.yandex.direct.api.v5.context.ApiContextHolder;

@Component
public class AuthenticationInterceptor implements EndpointInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationInterceptor.class);

    private final ApiContextHolder apiContextHolder;

    @Autowired
    public AuthenticationInterceptor(ApiContextHolder apiContextHolder) {
        this.apiContextHolder = apiContextHolder;
    }

    @Override
    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        logger.debug("authenticating incoming request: {}", messageContext.getRequest().getPayloadSource());

        ApiContext apiContext = apiContextHolder.get();
        DirectApiAuthentication auth = apiContext.getDirectApiAuthenticationOrFail();
        SecurityContextHolder.getContext().setAuthentication(auth);

        return true;
    }

    @Override
    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    @Override
    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    @Override
    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception ex) throws Exception {
        SecurityContextHolder.clearContext();
    }
}
