package ru.yandex.direct.api.v5.security;

import java.net.InetAddress;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.core.entity.user.model.ApiUser;
import ru.yandex.direct.core.security.DirectAuthentication;

/**
 * Предоставляет доступ к аутентифицированным оператору, клиенту и главным представителям.
 */
@ParametersAreNonnullByDefault
public class DirectApiAuthentication extends DirectAuthentication {

    /**
     * Главный представитель оператора
     */
    private final ApiUser chiefOperator;
    /**
     * Главный представитель субклиента (В случае прямого клиента совпадает с {@link #chiefOperator}
     */
    private final ApiUser chiefSubclient;

    /**
     * Был ли header Client-Login в запросе пуст
     */
    private final boolean clientLoginIsEmpty;

    /**
     * Идентификатор приложения
     */
    private final String applicationId;


    public DirectApiAuthentication(ApiUser operator, ApiUser chiefOperator, ApiUser subclient, ApiUser chiefSubclient,
                                   InetAddress userIp) {
        this(operator, chiefOperator, subclient, chiefSubclient, false, null, "", userIp);
    }

    public DirectApiAuthentication(ApiUser operator, ApiUser chiefOperator,
                                   ApiUser subclient, ApiUser chiefSubclient, boolean clientLoginIsEmpty,
                                   @Nullable String tvmUserTicket, String applicationId,
                                   InetAddress userIp) {
        super(operator, subclient, tvmUserTicket, userIp);
        this.chiefOperator = chiefOperator;
        this.chiefSubclient = chiefSubclient;
        this.clientLoginIsEmpty = clientLoginIsEmpty;
        this.applicationId = applicationId;
    }

    @Override
    public ApiUser getOperator() {
        return (ApiUser) super.getOperator();
    }

    public ApiUser getChiefOperator() {
        return chiefOperator;
    }

    @Override
    public ApiUser getSubjectUser() {
        return (ApiUser) super.getSubjectUser();
    }

    public ApiUser getChiefSubclient() {
        return chiefSubclient;
    }

    public boolean isClientLoginEmpty() {
        return clientLoginIsEmpty;
    }

    public String getApplicationId() {
        return applicationId;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
