package ru.yandex.direct.api.v5.security;

import javax.annotation.Nonnull;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.security.internal.DirectApiInternalAuthProvider;
import ru.yandex.direct.api.v5.security.internal.DirectApiInternalAuthRequest;

/**
 * Выполняет workflow аутентификации в API
 */
@Lazy
@Component
public class DirectApiAuthenticationManager implements ApiAuthenticationManager {

    private final DirectApiInternalAuthProvider directApiInternalAuthProvider;

    @Autowired
    public DirectApiAuthenticationManager(DirectApiInternalAuthProvider directApiInternalAuthProvider) {
        this.directApiInternalAuthProvider = directApiInternalAuthProvider;
    }

    /**
     * Первый шаг аутентификации -- выполнить предварительные проверки возможности пользовать API для этого оператора
     */
    @Nonnull
    @Override
    public DirectApiPreAuthentication checkApiAccessAllowed(DirectApiInternalAuthRequest authRequest) {
        // Попытаться аутентифицировать пользователя на основе полученных из token-а данных
        return directApiInternalAuthProvider.checkApiAccessAllowed(authRequest);
    }

    /**
     * Второй шаг аутинтификации -- определение целевого пользователя и предварительные проверки возможности
     * работать с ним через API
     */
    @Nonnull
    @Override
    public DirectApiPreAuthentication checkClientLoginAccess(DirectApiPreAuthentication authenticationCarrier) {
        return directApiInternalAuthProvider.checkClientLoginAccess(authenticationCarrier);
    }
}
