package ru.yandex.direct.api.v5.security;

import ru.yandex.direct.api.v5.security.exception.AccessToApiDeniedException;
import ru.yandex.direct.api.v5.security.exception.AuthenticationException;
import ru.yandex.direct.api.v5.security.exception.AuthenticationServiceException;
import ru.yandex.direct.api.v5.security.exception.BadCredentialsException;
import ru.yandex.direct.api.v5.security.exception.NoRegistrationException;
import ru.yandex.direct.api.v5.security.exception.NotClientInClientLoginException;
import ru.yandex.direct.api.v5.security.exception.TokenAbsentOrHasInvalidFormatException;
import ru.yandex.direct.api.v5.security.exception.UnknownLoginInClientLoginOrFakeLoginException;
import ru.yandex.direct.api.v5.security.exception.UnknownUserException;

public final class SecurityErrors {
    public static AuthenticationException newAbsentOauthToken() {
        return TokenAbsentOrHasInvalidFormatException.newAbsentOauthToken();
    }

    public static AuthenticationException newInvalidOauthTokenFormat(Throwable cause) {
        return TokenAbsentOrHasInvalidFormatException.newInvalidOauthTokenFormat(cause);
    }

    public static AuthenticationException newExpiredOauthToken(Throwable cause) {
        return BadCredentialsException.newExpiredOauthToken(cause);
    }

    public static AuthenticationException newPersistentTokenNotFound() {
        return BadCredentialsException.newExpiredOauthToken(null);
    }

    public static AuthenticationException newInvalidOauthToken() {
        return BadCredentialsException.newExpiredOauthToken(null);
    }

    public static AuthenticationException newInternalBlackboxError(Throwable cause) {
        return new AuthenticationServiceException("error at Blackbox authentication", cause);
    }

    public static AuthenticationException newApplicationIdNotRegistered() {
        return new NoRegistrationException("negative result of access check by applicationId");
    }


    public static AuthenticationException newUnknownLoginInClientLogin(String login) {
        throw UnknownLoginInClientLoginOrFakeLoginException.newUnknownLoginInClientLogin();
    }

    public static AuthenticationException newUnknownFakeLogin(String fakeLogin) {
        throw UnknownLoginInClientLoginOrFakeLoginException.newUnknownLoginInFakeLogin();
    }

    public static AuthenticationException newClientLoginNotMatchedToToken() {
        return UnknownLoginInClientLoginOrFakeLoginException.newUnknownLoginInClientLogin();
    }

    public static AuthenticationException newOperatorHasNotRightsOnTargetSubject() {
        return UnknownLoginInClientLoginOrFakeLoginException.newOperatorHasNotRightsOnTargetSubject();
    }


    public static AuthenticationException newUserUidNotFound(Long uid) {
        return new UnknownUserException("Не найден оператор в базе Директа");
    }


    public static AuthenticationException newClientLoginRequiredForOperator() {
        return NotClientInClientLoginException.newClientLoginRequiredForOperator();
    }

    public static AuthenticationException newClientLoginRequiredForAgency() {
        return NotClientInClientLoginException.newClientLoginRequiredForAgency();
    }

    public static AuthenticationException newTargetSubjectIsNotClient() {
        return NotClientInClientLoginException.newTargetSubjectIsNotClient();
    }

    public static AuthenticationException newTargetSubjectIsNotAgencyOrFreelancer() {
        return NotClientInClientLoginException.newTargetSubjectIsNotAgencyOrFreelancer();
    }

    public static AuthenticationException newClientLoginRequired() {
        return NotClientInClientLoginException.newClientLoginRequired();
    }

    public static AuthenticationException newTargetUserHasNotRequiredRole() {
        return NotClientInClientLoginException.newTargetUserHasNotRequiredRole();
    }

    public static AuthenticationException newAccessToApiDeniedAccessDisabled() {
        return AccessToApiDeniedException.newAccessToApiDeniedAccessDisabled();
    }

    public static AuthenticationException newAccessToApiDeniedStatusBlocked() {
        return AccessToApiDeniedException.newAccessToApiDeniedStatusBlocked();
    }

    public static AuthenticationException newAccessToApiDeniedAccessFromExternalIp() {
        return AccessToApiDeniedException.newExternalIpDenied();
    }

    public static AuthenticationException newAccessToApiDeniedNotAllowedIp() {
        return AccessToApiDeniedException.newNotAllowedIpAddress();
    }

    public static AuthenticationException newAccessToApiDeniedWhileConvertingCurrency() {
        return AccessToApiDeniedException.newAccessToApiDeniedWhileConvertingCurrency();
    }

    public static AuthenticationException newAccessToApiDeniedForYaAgency() {
        return AccessToApiDeniedException.newYaAgencyDenied();
    }


    public static AuthenticationException newClientCantAccessAgencyService() {
        return AccessToApiDeniedException.newClientCantAccessAgencyService();
    }
}
