package ru.yandex.direct.api.v5.security;

import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;

import ru.yandex.direct.api.v5.ws.WsUtils;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;


/**
 * Дополнительные авторизационные проверки на api-сервисах, в зависимости от типа сервиса: клиентский или агентский
 * <p>
 * {@link ApiServiceType}
 */
@Component
public class ServiceAuthInterceptor implements EndpointInterceptor {
    private final ApiAuthenticationSource apiAuthenticationSource;
    private final DirectApiAuthorizationHelper authorizationHelper;

    @Autowired
    public ServiceAuthInterceptor(
            ApiAuthenticationSource apiAuthenticationSource, DirectApiAuthorizationHelper authorizationHelper) {
        this.apiAuthenticationSource = Objects.requireNonNull(apiAuthenticationSource, "apiAuthenticationSource");
        this.authorizationHelper = Objects.requireNonNull(authorizationHelper, "authorizationHelper");
    }

    @Override
    public boolean handleRequest(MessageContext messageContext, Object endpointObject) throws Exception {
        authorizationHelper.authorize(
                apiAuthenticationSource.getAuthentication(),
                WsUtils.getEndpointMethodOrClassMeta(endpointObject, ApiServiceType.class).type(),
                WsUtils.getEndpointMethodMeta(endpointObject, ApiMethod.class).operation());
        return true;
    }

    @Override
    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    @Override
    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    @Override
    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception ex) throws Exception {
    }
}
