package ru.yandex.direct.api.v5.security.exception;

import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.core.security.AccessDeniedException;
import ru.yandex.direct.i18n.Translatable;

public class AccessToApiDeniedException extends AuthenticationException {
    private AccessToApiDeniedException(
            String internalMessage,
            Translatable detailedMessage) {
        super(internalMessage, 3000, ApiFaultTranslations.INSTANCE.accessToApiDenied(), detailedMessage);
    }

    public static AccessToApiDeniedException newAccessToApiDeniedAccessDisabled() {
        return new AccessToApiDeniedException(
                "У пользователя нет доступа к API",
                ApiFaultTranslations.INSTANCE.detailedAccountBlocked());
    }

    public static AccessToApiDeniedException newAccessToApiDeniedStatusBlocked() {
        return new AccessToApiDeniedException(
                "У пользователя заблокирован доступ в API",
                ApiFaultTranslations.INSTANCE.detailedAccountBlocked());
    }

    public static AccessToApiDeniedException newExternalIpDenied() {
        return new AccessToApiDeniedException(
                "Доступ возможен только из внутренней сети Яндекса",
                ApiFaultTranslations.INSTANCE.detailedAccountBlocked());
    }

    public static AccessToApiDeniedException newNotAllowedIpAddress() {
        return new AccessToApiDeniedException(
                "IP-адрес не входит в список допустимых",
                ApiFaultTranslations.INSTANCE.accessToApiDeniedNotAllowedIpAddress());
    }

    public static AccessToApiDeniedException newAccessToApiDeniedWhileConvertingCurrency() {
        return new AccessToApiDeniedException(
                "Клиент сейчас или скоро будет переводиться в валюту",
                ApiFaultTranslations.INSTANCE.accessToApiDeniedWhileConvertingCurrency());
    }

    public static AccessToApiDeniedException newYaAgencyDenied() {
        return new AccessToApiDeniedException(
                "Доступ к Ya-агенству в API запрещен",
                ApiFaultTranslations.INSTANCE.accessToApiDeniedForYaAgency());
    }

    public static AccessToApiDeniedException newClientCantAccessAgencyService() {
        throw new AccessDeniedException(
                "Нет прав для доступа в агентский сервис",
                ApiFaultTranslations.INSTANCE.detailedNoRightsForAgencyService());
    }
}
