package ru.yandex.direct.api.v5.security.exception;

import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.i18n.Translatable;

public class BadCredentialsException extends AuthenticationException {
    public static final String NO_API_ACCESS = "Доступ к API заблокирован";

    public BadCredentialsException(String internalMessage, Throwable cause, Translatable detailedMessage) {
        super(internalMessage, cause, 53, ApiFaultTranslations.INSTANCE.badCredentials(), detailedMessage);
    }

    public BadCredentialsException(String internalMessage, Translatable detailedMessage) {
        super(internalMessage, 53, ApiFaultTranslations.INSTANCE.badCredentials(), detailedMessage);
    }

    public BadCredentialsException(String internalMessage) {
        this(internalMessage, null);
    }

    public static BadCredentialsException newExpiredOauthToken(Throwable cause) {
        return new BadCredentialsException(
                "Недействительный OAuth-токен",
                cause,
                ApiFaultTranslations.INSTANCE.expiredOauthToken());
    }
}
