package ru.yandex.direct.api.v5.security.exception;

import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.i18n.Translatable;

public final class NotClientInClientLoginException extends AuthenticationException {
    private NotClientInClientLoginException(String internalMessage, Translatable detail) {
        super(internalMessage, 8000, ApiFaultTranslations.INSTANCE.incorrectRequest(), detail);
    }

    public static NotClientInClientLoginException newClientLoginRequiredForOperator() {
        return new NotClientInClientLoginException(
                "Оператор не является клиентом, при этом логин клиента не указан",
                ApiFaultTranslations.INSTANCE.notClientInClientLogin());
    }

    public static NotClientInClientLoginException newClientLoginRequiredForAgency() {
        return new NotClientInClientLoginException(
                "Оператор не является агентством, при этом логин агенства не указан",
                ApiFaultTranslations.INSTANCE.notClientInClientLogin());
    }

    public static NotClientInClientLoginException newTargetSubjectIsNotClient() {
        return new NotClientInClientLoginException(
                "Пользователь с указанным Client-Login не является клиентом",
                ApiFaultTranslations.INSTANCE.notClientInClientLogin());
    }

    public static NotClientInClientLoginException newTargetSubjectIsNotAgencyOrFreelancer() {
        return new NotClientInClientLoginException(
                "Пользователь с указанным Client-Login не является агентством или фрилансером",
                ApiFaultTranslations.INSTANCE.detailedLoginIsNotAgency());
    }

    public static NotClientInClientLoginException newClientLoginRequired() {
        return new NotClientInClientLoginException(
                "Требуется указание Client-Login для работы с сервисом",
                ApiFaultTranslations.INSTANCE.notClientInClientLogin());
    }

    public static NotClientInClientLoginException newTargetUserHasNotRequiredRole() {
        return new NotClientInClientLoginException(
                "Пользователь с указанным Client-Login не имеет необходимой для работы с сервисом роли",
                ApiFaultTranslations.INSTANCE.notClientInClientLogin());
    }
}
