package ru.yandex.direct.api.v5.security.exception;

import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.Translatable;

public final class TokenAbsentOrHasInvalidFormatException extends AuthenticationException {
    public TokenAbsentOrHasInvalidFormatException(
            String internalMessage,
            Throwable cause,
            Translatable detailedMessage) {
        super(internalMessage, cause, 8000, CommonDefectTranslations.INSTANCE.invalidRequestShort(), detailedMessage);
    }

    public static TokenAbsentOrHasInvalidFormatException newAbsentOauthToken() {
        return new TokenAbsentOrHasInvalidFormatException(
                "OAuth-токен не указан",
                null,
                ApiFaultTranslations.INSTANCE.absentOauthToken());
    }

    public static TokenAbsentOrHasInvalidFormatException newInvalidOauthTokenFormat(Throwable cause) {
        return new TokenAbsentOrHasInvalidFormatException(
                "Неверный формат OAuth-токена",
                cause,
                ApiFaultTranslations.INSTANCE.invalidOauthTokenFormat());
    }
}
