package ru.yandex.direct.api.v5.security.exception;

import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.Translatable;

public final class UnknownLoginInClientLoginOrFakeLoginException extends AuthenticationException {
    private UnknownLoginInClientLoginOrFakeLoginException(
            String internalMessage, Translatable detail) {
        super(
                internalMessage,
                8800,
                CommonDefectTranslations.INSTANCE.notFoundShort(),
                detail);
    }

    public static UnknownLoginInClientLoginOrFakeLoginException newUnknownLoginInClientLogin() {
        return new UnknownLoginInClientLoginOrFakeLoginException(
                "Неизвестный логин в Client-Login",
                ApiFaultTranslations.INSTANCE.unknownLoginInClientLogin());
    }

    public static UnknownLoginInClientLoginOrFakeLoginException newUnknownLoginInFakeLogin() {
        return new UnknownLoginInClientLoginOrFakeLoginException(
                "Неизвестный логин в Fake-Login",
                ApiFaultTranslations.INSTANCE.unknownLoginInFakeLogin());
    }

    public static UnknownLoginInClientLoginOrFakeLoginException newOperatorHasNotRightsOnTargetSubject() {
        return new UnknownLoginInClientLoginOrFakeLoginException(
                "У оператора нет прав на указанного клиента",
                ApiFaultTranslations.INSTANCE.unknownLoginInClientLogin());
    }
}
