package ru.yandex.direct.api.v5.security.internal;

import java.util.Collection;

import javax.annotation.Nullable;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

import ru.yandex.direct.api.v5.security.DirectApiCredentials;
import ru.yandex.direct.web.auth.blackbox.BlackboxBasedAuth;

public class DirectApiInternalAuthRequest implements BlackboxBasedAuth {

    private final long uid;
    private final String login;
    private final String applicationId;
    private final DirectApiCredentials credentials;
    private final String tvmUserTicket;

    public DirectApiInternalAuthRequest(DirectApiCredentials credentials, Long uid,
                                        String login, String applicationId, String tvmUserTicket) {
        this.credentials = credentials;
        this.uid = uid;
        this.login = login;
        this.applicationId = applicationId;
        this.tvmUserTicket = tvmUserTicket;
        checkConsistency();
    }

    @Override
    public Long getUid() {
        return uid;
    }

    @Override
    public String getPrincipal() {
        return login;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public boolean isTokenPersistent() {
        return credentials.isTokenPersistent();
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    @Override
    public DirectApiCredentials getCredentials() {
        return credentials;
    }

    @Nullable
    @Override
    public String getTvmUserTicket() {
        return tvmUserTicket;
    }

    private void checkConsistency() {
        String requiredMessageTail = " is required for request for internal authentication";
        Assert.notNull(credentials, "credentials" + requiredMessageTail);
        Assert.notNull(uid, "uid" + requiredMessageTail);
        Assert.notNull(login, "login" + requiredMessageTail);
        Assert.notNull(applicationId, "applicationId" + requiredMessageTail);
    }
}
