package ru.yandex.direct.api.v5.security.token;

import java.util.Collection;

import org.springframework.security.core.GrantedAuthority;

import ru.yandex.direct.api.v5.security.DirectApiCredentials;
import ru.yandex.direct.web.auth.blackbox.BlackboxBasedAuth;

public class PersistentTokenAuth implements BlackboxBasedAuth {

    private final Long uid;
    private final String login;
    private final String applicationId;
    private final DirectApiCredentials credentials;

    public PersistentTokenAuth(DirectApiCredentials credentials, Long uid, String login, String applicationId) {
        this.credentials = credentials;
        this.uid = uid;
        this.login = login;
        this.applicationId = applicationId;
    }

    @Override
    public Long getUid() {
        return uid;
    }

    @Override
    public String getPrincipal() {
        return login;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    @Override
    public DirectApiCredentials getCredentials() {
        return credentials;
    }

    public String getApplicationId() {
        return applicationId;
    }

    @Override
    public Object getDetails() {
        return null;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }
}
