package ru.yandex.direct.api.v5.service;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.ws.WsUtils;
import ru.yandex.direct.core.service.RequestInfoProvider;
import ru.yandex.direct.tracing.Trace;

/**
 * Предоставляет сведения о текущем запросе
 */
@Service
public class ApiRequestInfoProvider implements RequestInfoProvider {
    /**
     * Идентификатор текущего запроса
     */
    @Nonnull
    public String getRequestId() {
        return Long.toString(Trace.current().getSpanId());
    }

    /**
     * Ip-адрес инициирующего запрос клиента
     */
    @Nonnull
    public String getRemoteIpAddress() {
        return WsUtils.getHttpServletRequest().getRemoteAddr();
    }
}
