package ru.yandex.direct.api.v5.service.accelinfo;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletResponse;

import com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.context.ApiContext;
import ru.yandex.direct.api.v5.context.ApiContextHolder;
import ru.yandex.direct.common.tracing.AccelInfoHeader;

@Component
@ParametersAreNonnullByDefault
public class AccelInfoHeaderSetter {

    private static final Logger logger = LoggerFactory.getLogger(AccelInfoHeaderSetter.class);

    private final ApiContextHolder apiContextHolder;

    @Autowired
    public AccelInfoHeaderSetter(ApiContextHolder apiContextHolder) {
        this.apiContextHolder = apiContextHolder;
    }

    /**
     * Проставить в HTTP ответ заголовок {@value AccelInfoHeader#HEADER_NAME}
     * на основе {@link ApiContext#appErrorCode}.
     * <p>
     * Метод нужно вызывать как можно позже до того, как ответ улетел клиенту – как в успешном сценарии,
     * так и если произошла ошибка. Во втором случае предполагается, что код ошибки записан в {@link ApiContext}.
     *
     * @see AccelInfoHeader
     */
    public void setAccelInfoHeaderToHttpResponse() {
        String headerValue = getHeaderStringValue();
        logger.debug("Set HTTP response header {}: {}", AccelInfoHeader.HEADER_NAME, headerValue);

        getHttpResponse().setHeader(AccelInfoHeader.HEADER_NAME, headerValue);
    }

    private HttpServletResponse getHttpResponse() {
        return apiContextHolder.get().getApiResponse();
    }

    private String getHeaderStringValue() {
        int appErrorCode = apiContextHolder.get().getAppErrorCode();
        return new AccelInfoHeader(ImmutableMap.of("appcode", Integer.toString(appErrorCode))).toString();
    }

}
