package ru.yandex.direct.api.v5.units.logging;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.context.units.UnitsLogData;

@Component
@ParametersAreNonnullByDefault
public class UnitsLogWriter {

    private static final Logger logger = LoggerFactory.getLogger(UnitsLogWriter.class);

    private final ObjectWriter objectWriter = new ObjectMapper()
            .setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE)
            .writerFor(UnitsLogData.class);

    /**
     * Записать данные о контексте баллов текущего запроса в лог в виде JSON.
     *
     * @param unitsLogData Структура, содержащая информацию об участниках запроса и списанных баллах.
     */
    public void write(UnitsLogData unitsLogData) {
        try {
            String json = toJson(unitsLogData);
            logger.info(json);
        } catch (JsonProcessingException e) {
            logger.error("Failed to print units log.", e);
        }
    }

    String toJson(UnitsLogData unitsLogData) throws JsonProcessingException {
        return objectWriter.writeValueAsString(unitsLogData);
    }

}
